
#ifdef fldebug


#include <standard.h>


#ifdef MACVERSION

	#include "memory.h"
	#include "strings.h"
	#include "ops.h"
	#include "shell.h"

#ifdef TARGET_API_MAC_CARBON
	#include "file.h"
	#include "launch.h"
	#include "timedate.h"
#endif

	short __assert (char *expr, char *file, short line) {

#ifdef TARGET_API_MAC_CARBON
	
		/*
		On OS X, DebugStr output gets automatically rerouted to stderr
		which in turn gets logged to console.log, viewable via Console.app.
		
		2003-05-26 AR: Include date/time, app name, and app version.
		*/
		
		static boolean flnorentry = false;
		short day, month, year, hour, minute, second;
		tyfilespec myfspec;
		bigstring bs, bslogstamp, bsline, bsfile, bsmessage;
		
		if (flnorentry)
			return (0);
		
		flnorentry = true;
		
		/*get timestamp*/
		
		secondstodatetime (timenow (), &day, &month, &year, &hour, &minute, &second);
		
		numbertostring ((long) year, bs);
		
		pushstring (bs, bslogstamp);
		
		pushchar ('-', bslogstamp);
		
		numbertostring ((long) month, bs);
		
		padwithzeros (bs, 2);
		
		pushstring (bs, bslogstamp);
		
		pushchar ('-', bslogstamp);
		
		numbertostring ((long) day, bs);
		
		padwithzeros (bs, 2);
		
		pushstring (bs, bslogstamp);
		
		pushchar (' ', bslogstamp);
		
		numbertostring ((long) hour, bs);
		
		padwithzeros (bs, 2);
		
		pushstring (bs, bslogstamp);
		
		pushchar (':', bslogstamp);
		
		numbertostring ((long) minute, bs);
		
		padwithzeros (bs, 2);
		
		pushstring (bs, bslogstamp);
		
		pushchar (':', bslogstamp);
		
		numbertostring ((long) second, bs);
		
		padwithzeros (bs, 2);
		
		pushstring (bs, bslogstamp);
		
		pushchar (' ', bslogstamp);

 		/*get filespec for app*/
 
		getapplicationfilespec (nil, &myfspec);
		
		pushstring (fsname (&myfspec), bslogstamp);
		
		pushchar (' ', bslogstamp);
		
		/*get version of app*/
		
		filegetprogramversion (bs);
		
		pushchar ('(', bslogstamp);
		
		pushstring (bs, bslogstamp);
		
		pushchar (')', bslogstamp);
		
		/*get file name*/
		
		moveleft (file, bsfile, (long) lenbigstring);
		
		convertcstring (bsfile);
		
		/*get line number*/
		
		numbertostring ((long) line, bsline);
		
		/*ouput message*/
		
		parsedialogstring (
				"\p\r^0: Assertion failed in file ^1, at line ^2.  Probably no big deal, but please tell frontier-bugs@userland.com.  Thanks!\r",
				bslogstamp, bsfile, bsline, nil,
				bsmessage);
				
		DebugStr (bsmessage);
		
		/*send message to stderr*/
		
		flnorentry = false;

#else
		
		bigstring bsfile, bsline, bsmessage;
		static boolean flnorentry = false;
		
		if (flnorentry)
			return (0);
		
		flnorentry = true;
		
		moveleft (file, bsfile, (long) lenbigstring);
		
		convertcstring (bsfile);
		
		numbertostring ((long) line, bsline);
		
		parsedialogstring (
				"\pAssertion failed in file ^0, at line ^1.  Probably no big deal, but please tell frontier-bugs@userland.com.  Thanks!",
				bsfile, bsline, nil, nil,
				bsmessage);
		
		DebugStr (bsmessage);
		
		flnorentry = false;

#endif
		return (0);
	} /*__assert*/

#endif	/* MACVERSION */
	

#ifdef WIN95VERSION

	#include "threads.h"
	#include <stdio.h>

	#ifdef _MSC_VER		/* 2002-11-09 AR: use _assert from debug version of Microsoft C runtime library*/

		#include <assert.h>
		#include <crtdbg.h>
		#include "threads.h"

		short __assert (char *expr, char *file, short line) {
			
			#ifdef _DEBUG

				static boolean flnorentry = false;
				
				if (flnorentry)
					return (0);
				
				flnorentry = true;

				releasethreadglobals ();
				
				_assert (expr, file, line);

				grabthreadglobals ();

				flnorentry = false;

			#endif	/*_DEBUG*/

			return (0);
			} /*__assert*/

	#endif	/* _MSC_VER */

	#ifdef __MWERKS__		/* 2002-11-09 AR: put up MessageBox with Cancel button to abort application */

		#undef abs
		#include <stdlib.h>

		short __assert (char *expr, char *file, short line) {
		
			#ifdef _DEBUG

				static boolean flnorentry = false;
				char buf[4096];
				int itemnum;
				
				if (flnorentry)
					return (0);
				
				flnorentry = true;

				sprintf(buf,"Assertion failed in %s, at line %d.\n\nExpression: %s\n\nProbably no big deal, but please tell frontier-bugs@userland.com. Thanks!\n", file, line, expr);
				
				//releasethreadglobals ();	/* 2002-11-10 AR: other threads should not continue running if we hit an assertion failure */
				
				itemnum = MessageBox (hwndMDIClient, buf, "Assertion Failure", MB_ABORTRETRYIGNORE | MB_ICONSTOP | MB_APPLMODAL);

				//grabthreadglobals ();

				flnorentry = false;
				
				if (itemnum == IDABORT)
					abort();

				if (itemnum == IDRETRY) {
				
					if (IsDebuggerPresent ())
						OutputDebugString (buf);
					
					DebugBreak();
					}

			#endif	/*_DEBUG*/

			return (0);
			} /*__assert*/

	#endif	/* __MWERKS__ */

#endif	/* WIN95VERSION */

#endif	/* fldebug */

